<?php

include '../settings.php';
include 'logincheck.php';

// check if we are in !edit mode
$articleId = $_POST["articleId"];
$newMode = empty($articleId);

// In PHP versions earlier than 4.1.0, $HTTP_POST_FILES should be used instead
// of $_FILES.
$fileName = basename($_FILES['document']['name']);
$uploadfile = $UPLOAD_DIR . $fileName;
$type = $_POST["type"];
$title = $_POST["title"];
$teaser = $_POST["teaser"];

debug("uploadData" , "ID $articleId File: $uploadfile Type: $type Title: $title Teaser: $teaser ");
debug("uploadData", "Name: " . $_FILES['document']['name'] . " Size: " . $_FILES['document']['size'] . " Tmp: " .$_FILES['userfile']['tmp_name'] );
$continue = true;

// if edit mode we have to check if the file name has been changed. If
// yes the former file must be deleted
if( !$newMode )
{
	// we are in edit mode . So we have to check if the new and the old name are not
	// identical
	$row = getArticle($articleId);
	// we should only delete the old file if we have an update situation (old == new)
	// or we get an new file and the new file does not exist!
	if( !empty($row["filename"]) && (
	    $row["filename"] == $fileName || 
	    ($row["filename"] != $fileName && !file_exists($uploadfile)) ) ) 
	{
		$oldFile = $UPLOAD_DIR . $row["filename"];
		unlink( $oldFile );
		$continue = true;
	}
	
}

// now we can check if the new file already exists
if( !empty( $fileName) && file_exists($uploadfile) )
{
	$TITLE = "Error: Cannot upload file '$fileName'! File already exists.";
	$continue = false;
}

// can we continue
if( $continue )
{
	if (move_uploaded_file($_FILES['document']['tmp_name'], $uploadfile)) 
	    debug("uploadData", "File is valid, and was successfully uploaded.");
	else
	    debug("uploadData", "Possible file upload attack!");
	
	// db connection
	if( $newMode )
		insertInDB($type, $title, $teaser, $fileName );
	else
		updateData($articleId, $type, $title, $teaser, $fileName );
}

include 'contents.php';

?>
