<?php
/**
 * The MENU contains a name, the menu label and the reference to a sub-page.
 * Furhtermore each menu can have sub-menus. Theser are specified in the SUBMENU
 * array. Again the key is the label.
 * 
 * If a menu does not contain a refernce to a sub-menu page, the first sub menu
 * item will be displayed.
 */
$MENU = array("Home" => "index.php",  
              "Company" => "company_profile.php",
			  "Service" => "service_cellcultivation.php",
			  "Laboratory" => "lab_equipment.php",
			  "Quality" => "qa_program.php" );
	
$SUBMENU = array("Home" => "",
					"Company" => array ("Profile" => "company_profile.php",
										"History" => "company_history.php",
										"Team" => "company_team.php",
                                        "Cooperation" => "company_cooperation.php",
                                        "Jobs" => "company_jobs.php" ),
					"Service" => array("Cell cultivation" => "service_cellcultivation.php",
									   "Protein purification" => "service_purification.php",
									   "Analytical procedures" => "service_analytical.php",
									   "Quality service" => "service_quality.php" ),
					"Laboratory" => array( "Equipment" => "lab_equipment.php",
										   "Clean rooms" => "lab_cleanrooms.php" ),
					"Quality" => array( "Quality program" => "qa_program.php",
										"Certificates" => "qa_certificates.php" )
					);

/**
 * Checks if a menu as a sub-menu
 *
 * @param unknown_type $menu
 * @return unknown
 */
function hasSubMenu( $menu )
{
	global $SUBMENU;

	return !empty( $SUBMENU[$menu]);
}

/**
 * Prints a menu list
 *
 * @param unknown_type $arr
 * @param unknown_type $selectItem
 * @param unknown_type $subMenu
 */
function printSubMenu( $menuName, $selectedItem  )
{
	global $SUBMENU;
	$arr = $SUBMENU[ $menuName ];
	
	reset($arr);
	$style = "class='sub'";
		 
	while (list($key, $val) = each($arr)) 
	{
		if( $selectedItem == $key )
			echo "<li class='active'><a $style href='$val' title='$key'>$key</a></li>";
		else
			echo "<li><a $style href='$val' title='$key'>$key</a></li>";
	}	
}
					
					
/**
 * Displays the menu tree. If a menu item is selected the sub-menu will be displayed.
 * If the menu has no sub-menu nothing will be displayed.
 * 
 * if the menu has no reference page, that means the reference is empty "", the first
 * sub-menu item will be selected.
 *
 * @param unknown_type $menu
 * @param unknown_type $subMenu
 */
function navigation( $menu, $subMenu = "" )
{
	global $MENU, $SUBMENU;

	echo "<ul class='menu-left'>";
	reset( $MENU );
	while (list($key, $val) = each($MENU)) 
	{
		if( $menu == $key )	
		{
			if( empty($subMenu))
				echo "<li class='active'><a href='$val' title='$key'>$key</a></li>";
			else
				echo "<li><a href='$val' title='$key'>$key</a></li>";
				
			if( hasSubMenu( $menu) )
				printSubMenu( $menu, $subMenu );
		}
		else
			echo "<li ><a href='$val' title='$key'>$key</a></li>";
	}
	
	echo "</ul>";
}

function siteMap()
{
	global $MENU, $SUBMENU;

	echo "<div class='folder'><ul>";
	reset( $MENU );
	while (list($key, $val) = each($MENU)) 
	{
		echo "<li><a href='$val'>$key</a>";
		if( hasSubMenu( $key) )
		{
			echo "<ol>";
			$subMenu = $SUBMENU[$key];
			while (list($skey, $sval) = each($subMenu))
			{
				echo "<li><a href='$sval'>$skey</a></li>";
			}
			echo "</ol>";
		}
		
		echo "</li>";
	}
	echo "</ul>";
}


function formatTimeStamp( $timeStamp )
{
	if( empty($timeStamp) )
	return "";

	// mysql format is YYYYMMDD
	if( strlen( $timeStamp ) == 8  )
	{
		$year = substr( $timeStamp, 0, 4);
		$month = substr( $timeStamp, 4, 2);
		$day = substr( $timeStamp, 6, 2);

		return $month . "/" . $day . "/" . $year;
	}
	else
	{
		list( $day, $hour ) = split( " ", $timeStamp );
		return $day;
	}
}

?>