<?php

//Debugausgabe
error_reporting(0); //E_ALL, 0
ini_set('display_errors', false);	//true,false
ini_set('default_mimetype', 'text/html');
//ini_set('default_charset', 'ISO-8859-1'); 
ini_set('default_charset', 'utf-8'); 

// Session starten
session_start();

// Klasse einbinden
include('validator.class.php');

$nameFehler = $emailFehler = $nachrichtFehler = $telFehler = $captchaFehler = $gesendet = false;
$fehlerfrei = true;

// Validator Objekt erzeugen
$formular = new Validator();

//Wird nur ausgeführt, wenn das Formular abgeschickt wurde
if(isset($_POST['senden']))
{
	//Formular checken
	//Name checken
	$name = $formular->pruefeName($_POST['name'], 'Name', 5, 50);
	if($name == false)
	{
		$fehlerfrei = false;
		$nameFehler = true;
	}		

	//Mail checken
	$email = $formular->pruefeEmail($_POST['email'], 'Email');
	if($email == false)
	{
		//Falls Mail ungültig, kann es ja noch eine Telefonnummer sein... also auf Telnr checken
		$tel = $formular->pruefeTelefon($_POST['email'], 'Telefonnummer');
		if($tel == false)
		{
			$fehlerfrei = false;
			$emailFehler = true;
		}
	}
	//Text checken
	$text = $formular->pruefeText($_POST['text'], 'Nachricht', 15, 1500);
	if($text == false)
	{
		$fehlerfrei = false;
		$nachrichtFehler = true;
	}

	//Sicherheitscode richtig eingegeben?
	if(md5($_POST['code']) != $_SESSION['captchaCode'])
	{
		$fehlerfrei = false;
		$captchaFehler = true;
	}

	//Position checken, falls ein ungültiger Wert eingeben wurde in der Adresszeile, dann bleibt die Seite oben
	$pos = $formular->pruefeZahl($_POST['sitePos'], 'sitePos');
	if($pos == false)
		$pos = 0;
		
	//Formular ist ok, Mail abschicken
	if($fehlerfrei)
	{
		//Datum und Uhrzeit nehmen
		$datetime = date("Y-m-d H:i:s");
		$date = date("Y-m-d");
		$time = date("H:i:s");
		//IP-Adresse wird gespeichert
		$ipadr = $_SERVER['REMOTE_ADDR'];
		//User-Info wird gespeichert... aber nicht benutzt..
		$nutzerinfo = $_SERVER['HTTP_USER_AGENT'];

		//Zusammenbauen der E-Mail
		//Empfaenger
		//$empfaenger = "Lukas <lukasdorsz@gmail.com>";
		$empfaenger = "Matthias Marx <matthias.marx@arcor.de>";
		//$empfaenger = "Matthias Marx <info@mm-rechtsanwalt.de>";
		//Betreff
		$betreff = "Anfrage per Kontaktformular von mm-rechtsanwalt.de";
		//Headerinformationen
		$from = "From: Matthias Marx <info@mm-rechtsanwalt.de>\r\n";
		$from .= "Reply-To: info@mm-rechtsanwalt.de\r\n";

		//Eventuellen cc und bcc einfuegen
		//$from .= "Cc: cc_mail@example.com\r\n";
		//$from .= "Bcc: bcc_mail@example.com\r\n";
		
		//Text der E-Mail
		$mailtext = 'Diese E-Mail wurde am '.$date.' um '.$time.' von der IP-Adresse '.$ipadr.' generiert.
		
';
		if($name != false)
			$mailtext .= 'Name:		'.$name.'
';
		if($email != false)
			$mailtext .= 'E-Mail:	'.$email.'
';
		if($tel != false)
			$mailtext .= 'Telefon:	'.$tel.'
			
';
		$mailtext .= 'Anfrage:

';
		if($text != false)
			$mailtext .= $text;
		
		//Mail abschicken
		if(mail($empfaenger, $betreff, $mailtext, $from))
			$gesendet = true;
		else 
			$gesendet = false;
	}
		
}


?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html lang="en">
	<head>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<title>Matthias Marx - Rechtsanwalt | Kontakt</title>
		<link href="styles.css" rel="stylesheet" type="text/css">
		<script type="text/javascript">
			function clearFormular()
			{
				document.getElementById("name").value = '';
				document.getElementById("email").value = '';
				document.getElementById("text").value = '';
			}

			function getPos()
			{
				document.getElementById("sitePos").value = window.pageYOffset;
			}

			function naviFenster() 
			{

				var jpos = '<?php echo $pos; ?>';

				window.scrollTo(0, jpos);
			}
		</script>	
	</head>
	<body onload="naviFenster()">
		<div id="wrap">
			<div id="header">
				<a href="/">
					<img src="../images/logo.jpg" alt="Rechtsanwalt Matthis Marx" border="0" height="60" width="980">
				</a>
			</div> 
			<hr class="thickbar" noshadow=""> 
			<div id="nav"> 
				<ul> 
					<li><a class="menu" href="index.html">STARTSEITE</a></li>
					<li><a class="menu" href="kanzlei.html">KANZLEI</a></li>
					<li><a class="menu" href="person.html">ZUR PERSON</a></li>
					<li><a class="menu" href="termine.html">TERMINE</a></li>
					<li><a class="menuactive" href="kontakt.php">KONTAKT</a></li>
					<li><a class="menu" href="links.html">LINKS &amp; DOWNLOADS</a></li>
					<li><a class="menu" href="impressum.html">IMPRESSUM</a></li>
				</ul>
			</div> 
			<hr class="thinbar" noshadow=""> 
			<img src="../images/kontakt.jpg" alt="Kontakt" name="mm_img" id="mm_img" height="240" width="240"> 
			<div id="main"> 
				<h1>Kontakt</h1>
				<a name="kontaktform">
				<p>lextum Rechtsanwälte<br>Rechtsanwalt Matthias Marx<br> Lutherstra&szlig;e 1<br> 19053 Schwerin<br> <br>in Bürogemeinschaft mit<br> Rechtsanwalt Jens Wichmann</p>				
				</a>
				<table border="0" width="300"> 
					<tbody>
						<tr>
							<td>Telefon: </td> 
							<td>+49 (0)385 551 57 50</td>
						</tr>
						<tr> 
							<td>Fax: &nbsp;</td> <td>+49 (0)385 551 57 47</td> 
						</tr>
						<tr> 
							<td>E-Mail: </td> 
							<td>info@mm-rechtsanwalt.de</td>
						</tr>
						<tr>
							<td>vCard: </td>
							<td><a href="MatthiasMarx.vcf"><img style="border: 0px solid ; width: 61px; height: 61px;" alt=""src="qr-code%20vcard2.png"></a></td>
						</tr> 
					</tbody>
				</table> 
				<br><p>Oder schreiben Sie mir direkt eine Nachricht per Kontaktformular:</p> 
				
					<?php
						if(isset($_POST['senden']) && $gesendet == false)
							echo('<p><span style="color: #FF0000;">Ihre Nachricht konnte nicht versandt werden!<br>Bitte &uuml;berpr&uuml;fen Sie Ihre Angaben.</span></p>');
						if(isset($_POST['senden']) && $gesendet == true)
							echo('<p><span style="color: #FF0000;">Ihre Nachricht wurde versandt.</span></p>');
					?>
					<form name="questionForm" id="questionForm" accept-charset="utf-8" action="<?php echo $_SERVER['PHP_SELF']; ?>" onsubmit="getPos()" method="post">
						<table border="0" width="70%">
							<tr>
								<td width="35%">
									<?php echo $nameFehler ? '<span style="color: #FF0000;">Ihr Name:</span>' : 'Ihr Name:';?>
								</td>
								<td width="65" align="right">
									<input type="text" size="50" maxlength="50" id="name" name="name" value="<?php if((!$fehlerfrei) || ($fehlerfrei==true && $gesendet==false)) echo $_POST['name']; ?>"/>
								</td>
							</tr>
							<tr>									
								<td><?php echo $emailFehler ? '<span style="color: #FF0000;">Ihre E-Mail oder Telefonnummer:</span>' : 'Ihre E-Mail oder Telefonnummer:';?></td>
								<td align="right">
									<input type="text" size="50" maxlength="50" id="email" name="email" value="<?php if((!$fehlerfrei) || ($fehlerfrei==true && $gesendet==false)) echo $_POST['email']; ?>"/>
								</td>
							</tr>
							<tr>
								<td><?php echo $nachrichtFehler ? '<span style="color: #FF0000;">Ihre Anfrage:</span>' : 'Ihre Anfrage:';?></td>
							</tr>
							<tr>
								<td colspan="2">
									<textarea cols="60" rows="6" wrap="soft" id="text" name="text"><?php if((!$fehlerfrei) || ($fehlerfrei==true && $gesendet==false)) echo $_POST['text'];?></textarea>
								</td>
							</tr>
						</table>
						
						<img src="captcha.php" alt="Sicherheitscode" title="Sicherheitscode" width="80" height="25" />
						<?php echo $captchaFehler ? '<span style="color: #FF0000;">&nbsp;&nbsp;&nbsp;Bitte Sicherheitscode eingeben:&nbsp;&nbsp;&nbsp;</span>' : '&nbsp;&nbsp;&nbsp;Bitte Sicherheitscode eingeben:&nbsp;&nbsp;&nbsp;';?>
						<input name="code" id="code" type="text" />

					    <input type="hidden" name="sitePos" id="sitePos" value="">

						<table>
							<tr>
								<td>
									<input type="submit" name="senden" id="senden" value="Abschicken"/>
								</td>
								<td>
									<input type="button" name="abbrechen" value="Abbrechen" onclick="clearFormular()">

								</td>
							</tr>
						</table>
					</form>
				<br>
				<h1>Wegbeschreibung&nbsp;</h1>
				<p>So finden Sie mich:</p> 
				<iframe width="425" height="350" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.de/maps?oe=utf-8&amp;client=firefox-a&amp;q=schwerin+lutherstra%C3%9Fe+1&amp;ie=UTF8&amp;hq=&amp;hnear=Lutherstra%C3%9Fe+1,+19053+Schwerin,+Mecklenburg-Vorpommern&amp;gl=de&amp;t=m&amp;ll=53.620158,11.408958&amp;spn=0.008909,0.018239&amp;z=15&amp;iwloc=A&amp;output=embed"></iframe><br /><small><a href="https://maps.google.de/maps?oe=utf-8&amp;client=firefox-a&amp;q=schwerin+lutherstra%C3%9Fe+1&amp;ie=UTF8&amp;hq=&amp;hnear=Lutherstra%C3%9Fe+1,+19053+Schwerin,+Mecklenburg-Vorpommern&amp;gl=de&amp;t=m&amp;ll=53.620158,11.408958&amp;spn=0.008909,0.018239&amp;z=15&amp;iwloc=A&amp;source=embed" style="color:#0000FF;text-align:left">Größere Kartenansicht</a></small>
				<p></p> 
			</div> 
			<div id="footer"> <hr class="thinbar" noshadow="">
				<ul> 
					<li><a href="index.html" class="navfooter">STARTSEITE</a></li>
					<li><a href="kontakt.php" class="navfooter">KONTAKT</a></li>
					<li><a href="impressum.html" class="navfooter">IMPRESSUM</a></li> 
				</ul> 
				<p>© 2010 Rechtsanwalt Matthias Marx</p> 
			</div>
		</div>
	</body>
</html>
